using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.DAL;
using VIRP.EFR.UTIL;

namespace VIRP.EFR.BLL
{
    public static partial class STD_TEST_NAMEManager
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static VIRP.EFR.BO.STD_TEST_NAME GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            VIRP.EFR.BO.STD_TEST_NAME objReturn = null;
            STD_TEST_NAMEDB objDB = new STD_TEST_NAMEDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static List<VIRP.EFR.BO.STD_TEST_NAME> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<VIRP.EFR.BO.STD_TEST_NAME> objReturn = null;
            STD_TEST_NAMEDB objDB = new STD_TEST_NAMEDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetActiveOrderedTestNames(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            var db = new STD_ANALYTETYPEDB();

            var tests = db.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                .Where(t => t.INACTIVE_FLAG == false)
                .OrderBy(t => t.NAME)
                .Select(t => new KeyValuePair<int, string>(t.ID, t.NAME))
                .ToList();

            var comparer = new KeyValueComparer();

            tests.Sort(comparer);

            return tests;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_TEST_NAME objSave)
        {
            Int32 objReturn = 0;
            STD_TEST_NAMEDB objDB = new STD_TEST_NAMEDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            Boolean objReturn = false;
            STD_TEST_NAMEDB objDB = new STD_TEST_NAMEDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VIRP.EFR.BO.STD_TEST_NAME objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.ID);
        }

        #endregion
    }
}
